/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.ThrownShoe;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityCloud;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.gui.GuiInterface;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class Girlfriend
extends EntityLiving {
    public Texture[] drytexture = null;
    public Texture[] wettexture = null;
    private Texture princess1texture = null;
    private Texture princess2texture = null;
    private Texture dargonprincesstexture = null;
    public int secondcounter = 0;
    public int sound_busy = 0;
    public int dance_ticker = 0;
    public int dance_move = 0;
    public int is_dancing = 0;

    public Girlfriend(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.75f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Girlfriend";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(5.0f);
        this.attackRange = 3.5f;
        this.movefrequency = 45;
        this.setExperience(50);
        this.searchDistance = 14.0f;
        this.canSwim = true;
        this.setCanDespawn(false);
        this.maxdisttoowner = 16.0f;
        if (w != null) {
            this.setBID(-1);
            this.setBID(w.rand.nextInt(41));
            this.setIID(w.rand.nextInt(18));
            this.setVarFloat(21, (w.rand.nextFloat() - w.rand.nextFloat()) * 0.15f);
        } else {
            this.setBID(-1);
            this.setBID(DangerZone.rand.nextInt(41));
            this.setIID(DangerZone.rand.nextInt(18));
            this.setVarFloat(21, (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.15f);
        }
        this.drytexture = new Texture[41];
        this.wettexture = new Texture[18];
        this.has_inventory = true;
        this.enable_followfood = true;
        this.isImmuneToFire = true;
        this.foodsearchDistance = 12;
        this.tower_defense_enable = false;
        this.avoiddistance = 20;
    }

    public void init() {
        super.init();
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e.temperament == 1;
    }

    public float getLivingSoundPitch() {
        return 1.0f + this.getVarFloat(21);
    }

    public boolean isFoodBlock(int foodid) {
        return foodid == Blocks.flower_red.blockID;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (this.world.isServer && e != this && e != null) {
            this.hurtMe = null;
            this.setStaying(false);
            if (!(e instanceof Player) && !DangerZone.playnicely) {
                this.hurtMe = e;
            }
        }
        super.doAttackFrom(e, dt, pain);
    }

    public Entity findSomethingToAttack() {
        if (this.getOwnerName() == null) {
            return null;
        }
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.getWidth() / 2.0f + this.searchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!this.isSuitableTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (!this.world.isServer) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (this.getOwnerName() != null) {
            if (this.getDistanceFromEntity(e) > (double)this.maxdisttoowner) {
                return false;
            }
            if (e instanceof Girlfriend) {
                Player pl;
                Girlfriend gf = (Girlfriend)e;
                return gf.getOwnerName() == null && (pl = (Player)DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && pl.getDistanceFromEntity((Entity)gf) < 6.0;
            }
        }
        if (e.temperament != 1) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(12) != 1) {
            return null;
        }
        if (this.getStaying()) {
            return null;
        }
        if (this.getQuiet()) {
            return null;
        }
        if (this.getAttacking()) {
            return null;
        }
        if (this.sound_busy > 0) {
            return null;
        }
        if (this.getOwnerName() != null) {
            if (this.posy < 50.0 && this.world.rand.nextInt(3) != 0) {
                return null;
            }
            this.sound_busy = 30;
            if (DangerZone.thundercount > 0 && this.world.rand.nextBoolean()) {
                return "OreSpawn:o_thunder";
            }
            if (this.world.rand.nextInt(4) == 1 && this.isRaining()) {
                return "OreSpawn:o_rain";
            }
            if (this.getHealth() >= this.getMaxHealth()) {
                int which;
                if (this.getInLiquid()) {
                    which = this.world.rand.nextInt(2);
                    if (which == 0) {
                        return "OreSpawn:o_water1";
                    }
                    if (which == 1) {
                        return "OreSpawn:o_water2";
                    }
                }
                if (!this.world.isDaytime() && this.world.rand.nextBoolean()) {
                    return "OreSpawn:o_dark";
                }
                which = this.world.rand.nextInt(7);
                if (which == 0) {
                    return "OreSpawn:o_happy1";
                }
                if (which == 1) {
                    return "OreSpawn:o_happy2";
                }
                if (which == 2) {
                    return "OreSpawn:o_happy3";
                }
                if (which == 3) {
                    return "OreSpawn:o_happy4";
                }
                if (which == 4) {
                    return "OreSpawn:o_happy5";
                }
                if (which == 5) {
                    return "OreSpawn:o_happy6";
                }
                if (which == 6) {
                    return "OreSpawn:o_happy7";
                }
            } else {
                int which = this.world.rand.nextInt(9);
                if (which == 0) {
                    return "OreSpawn:o_hurt1";
                }
                if (which == 1) {
                    return "OreSpawn:o_hurt2";
                }
                if (which == 2) {
                    return "OreSpawn:o_hurt3";
                }
                if (which == 3) {
                    return "OreSpawn:o_hurt4";
                }
                if (which == 4) {
                    return "OreSpawn:o_hurt5";
                }
                if (which == 5) {
                    return "OreSpawn:o_hurt6";
                }
                if (which == 6) {
                    return "OreSpawn:o_hurt7";
                }
                if (which == 7) {
                    return "OreSpawn:o_hurt8";
                }
                if (which == 8) {
                    return "OreSpawn:o_hurt9";
                }
            }
        }
        return null;
    }

    public void onKill(Entity deadthing) {
        int which = this.world.rand.nextInt(4);
        String killsound = null;
        this.sound_busy = 20;
        if (which == 0) {
            killsound = "OreSpawn:o_woohoo1";
        }
        if (which == 1) {
            killsound = "OreSpawn:o_woohoo2";
        }
        if (which == 2) {
            killsound = "OreSpawn:o_woohoo3";
        }
        if (which == 3) {
            killsound = "OreSpawn:o_woohoo4";
        }
        if (killsound != null) {
            this.world.playSound(killsound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        }
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(8);
        this.sound_busy = 20;
        if (which == 0) {
            return "OreSpawn:o_ow1";
        }
        if (which == 1) {
            return "OreSpawn:o_ow2";
        }
        if (which == 2) {
            return "OreSpawn:o_ow3";
        }
        if (which == 3) {
            return "OreSpawn:o_ow4";
        }
        if (which == 4) {
            return "OreSpawn:o_ow5";
        }
        if (which == 5) {
            return "OreSpawn:o_ow6";
        }
        if (which == 6) {
            return "OreSpawn:o_ow7";
        }
        if (which == 7) {
            return "OreSpawn:o_ow8";
        }
        return null;
    }

    public String getDeathSound() {
        if (this.getOwnerName() != null) {
            return "OreSpawn:o_death_girlfriend";
        }
        return "OreSpawn:o_death_single";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophygirlfriend.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.getOwnerName() != null) {
            Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        int howmany = this.world.rand.nextInt(5) + 3;
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.blackheels.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(5) + 3;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.redheels.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(5) + 3;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.boots.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = this.world.rand.nextInt(5) + 3;
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.slippers.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        super.doDeathDrops();
    }

    public void doDeathDropsNotGirl() {
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.drytexture[0] == null) {
            this.drytexture[0] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend0.png");
            this.drytexture[1] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend1.png");
            this.drytexture[2] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend2.png");
            this.drytexture[3] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend3.png");
            this.drytexture[4] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend4.png");
            this.drytexture[5] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend5.png");
            this.drytexture[6] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend6.png");
            this.drytexture[7] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend7.png");
            this.drytexture[8] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend8.png");
            this.drytexture[9] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend9.png");
            this.drytexture[10] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend10.png");
            this.drytexture[11] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend11.png");
            this.drytexture[12] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend12.png");
            this.drytexture[13] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend13.png");
            this.drytexture[14] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend14.png");
            this.drytexture[15] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend15.png");
            this.drytexture[16] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend16.png");
            this.drytexture[17] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend17.png");
            this.drytexture[18] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend18.png");
            this.drytexture[19] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend19.png");
            this.drytexture[20] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend20.png");
            this.drytexture[21] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend21.png");
            this.drytexture[22] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend22.png");
            this.drytexture[23] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend23.png");
            this.drytexture[24] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend24.png");
            this.drytexture[25] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend25.png");
            this.drytexture[26] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend26.png");
            this.drytexture[27] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend27.png");
            this.drytexture[28] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend28.png");
            this.drytexture[29] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend29.png");
            this.drytexture[30] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend30.png");
            this.drytexture[31] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend31.png");
            this.drytexture[32] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend32.png");
            this.drytexture[33] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend33.png");
            this.drytexture[34] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend34.png");
            this.drytexture[35] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend35.png");
            this.drytexture[36] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend36.png");
            this.drytexture[37] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend37.png");
            this.drytexture[38] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend38.png");
            this.drytexture[39] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend39.png");
            this.drytexture[40] = TextureMapper.getTexture((String)"orespawnres/skins/girlfriend40.png");
            this.wettexture[0] = TextureMapper.getTexture((String)"orespawnres/skins/bikini0.png");
            this.wettexture[1] = TextureMapper.getTexture((String)"orespawnres/skins/bikini1.png");
            this.wettexture[2] = TextureMapper.getTexture((String)"orespawnres/skins/bikini2.png");
            this.wettexture[3] = TextureMapper.getTexture((String)"orespawnres/skins/bikini3.png");
            this.wettexture[4] = TextureMapper.getTexture((String)"orespawnres/skins/bikini4.png");
            this.wettexture[5] = TextureMapper.getTexture((String)"orespawnres/skins/bikini5.png");
            this.wettexture[6] = TextureMapper.getTexture((String)"orespawnres/skins/bikini6.png");
            this.wettexture[7] = TextureMapper.getTexture((String)"orespawnres/skins/bikini7.png");
            this.wettexture[8] = TextureMapper.getTexture((String)"orespawnres/skins/bikini8.png");
            this.wettexture[9] = TextureMapper.getTexture((String)"orespawnres/skins/bikini9.png");
            this.wettexture[10] = TextureMapper.getTexture((String)"orespawnres/skins/bikini10.png");
            this.wettexture[11] = TextureMapper.getTexture((String)"orespawnres/skins/bikini11.png");
            this.wettexture[12] = TextureMapper.getTexture((String)"orespawnres/skins/bikini12.png");
            this.wettexture[13] = TextureMapper.getTexture((String)"orespawnres/skins/bikini13.png");
            this.wettexture[14] = TextureMapper.getTexture((String)"orespawnres/skins/bikini14.png");
            this.wettexture[15] = TextureMapper.getTexture((String)"orespawnres/skins/bikini15.png");
            this.wettexture[16] = TextureMapper.getTexture((String)"orespawnres/skins/bikini16.png");
            this.wettexture[17] = TextureMapper.getTexture((String)"orespawnres/skins/bikini17.png");
            this.princess1texture = TextureMapper.getTexture((String)"orespawnres/skins/FrogPrincess.png");
            this.princess2texture = TextureMapper.getTexture((String)"orespawnres/skins/FrogPrincess2.png");
            this.dargonprincesstexture = TextureMapper.getTexture((String)"orespawnres/skins/DargonPrincess.png");
        }
        if (this.getInLiquid()) {
            return this.wettexture[this.getIID()];
        }
        if (this.getVarInt(21) == 1) {
            return this.princess1texture;
        }
        if (this.getVarInt(21) == 2) {
            return this.princess2texture;
        }
        if (this.getVarInt(21) == 3) {
            return this.dargonprincesstexture;
        }
        return this.drytexture[this.getBID()];
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() == null) {
                if (this.world.rand.nextInt(3) == 1) {
                    this.setOwnerName(p.myname);
                    Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                    this.setHealth(this.getMaxHealth());
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && p.myname.equals(this.getOwnerName())) {
                if (this.getHealth() < this.getMaxHealth()) {
                    Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                    this.setHealth(this.getMaxHealth());
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    return true;
                }
                return false;
            }
            if (ic != null && Items.isFood((int)ic.iid) && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                if (this.getHealth() < this.getMaxHealth()) {
                    Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)10, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                    this.playburp();
                    this.heal(Items.getFoodValue((int)ic.iid));
                    return true;
                }
                return false;
            }
            if (ic != null && ic.bid == Blocks.flower_yellow.blockID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)10, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                int which = 0;
                if (this.getInLiquid()) {
                    which = this.getIID();
                    if (++which > 17) {
                        which = 0;
                    }
                    this.setIID(which);
                } else {
                    which = this.getBID();
                    if (++which > 40) {
                        which = 0;
                    }
                    this.setBID(which);
                }
                return true;
            }
            if (ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                this.heal(1.0f);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && ic.iid == Items.vampireteeth.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSmoke", (int)10, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                this.setStaying(false);
                this.setOwnerName(null);
                this.setPetName(null);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && ic.iid == OreSpawnMain.ruby.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                this.setQuiet(true);
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSmoke", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && ic.iid == OreSpawnMain.amethyst.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                this.setQuiet(false);
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                if (ic != null) {
                    Item itm = ic.getItem();
                    if (itm instanceof ItemArmor) {
                        ItemArmor ia = (ItemArmor)itm;
                        InventoryContainer tempic = this.getArmor(ia.armortype);
                        if (this.willWearIt(ic)) {
                            this.setArmor(ia.armortype, ic);
                            p.setHotbar(p.gethotbarindex(), tempic);
                        }
                    } else {
                        InventoryContainer tempic = this.getHotbar(this.gethotbarindex());
                        this.setHotbar(this.gethotbarindex(), ic);
                        p.setHotbar(p.gethotbarindex(), tempic);
                        if (itm != null && itm.itemID == Items.diamond.itemID) {
                            this.setStaying(true);
                        } else {
                            this.setStaying(false);
                        }
                    }
                } else {
                    InventoryContainer tempic = this.getHotbar(this.gethotbarindex());
                    if (tempic == null) {
                        tempic = this.getArmor(3);
                        if (tempic != null) {
                            this.setArmor(3, null);
                            p.setHotbar(p.gethotbarindex(), tempic);
                        } else {
                            tempic = this.getArmor(2);
                            if (tempic != null) {
                                this.setArmor(2, null);
                                p.setHotbar(p.gethotbarindex(), tempic);
                            } else {
                                tempic = this.getArmor(1);
                                if (tempic != null) {
                                    this.setArmor(1, null);
                                    p.setHotbar(p.gethotbarindex(), tempic);
                                } else {
                                    tempic = this.getArmor(0);
                                    if (tempic != null) {
                                        this.setArmor(0, null);
                                        p.setHotbar(p.gethotbarindex(), tempic);
                                    }
                                }
                            }
                        }
                        if (tempic == null) {
                            this.setStaying(false);
                        }
                    } else {
                        this.setHotbar(this.gethotbarindex(), ic);
                        p.setHotbar(p.gethotbarindex(), tempic);
                        this.setStaying(false);
                    }
                }
                return false;
            }
        } else if (ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
            DangerZone.petnamegui.pet = this;
            DangerZone.setActiveGui((GuiInterface)DangerZone.petnamegui);
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            return false;
        }
        return false;
    }

    public boolean willWearIt(InventoryContainer ic) {
        if (ic == null) {
            return false;
        }
        if (ic.iid == OreSpawnMain.tigerseyeboots.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.tigerseyehelmet.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.tigerseyechestplate.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.tigerseyeleggings.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.pinkboots.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.pinkhelmet.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.pinkchestplate.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.pinkleggings.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.queenboots.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.queenhelmet.itemID) {
            return true;
        }
        if (ic.iid == OreSpawnMain.queenchestplate.itemID) {
            return true;
        }
        return ic.iid == OreSpawnMain.queenleggings.itemID;
    }

    public void findNewTargetNearOwner(Entity e) {
        if (this.target == null) {
            this.target = new TargetHelper(e.posx, e.posy, e.posz);
        }
        int tries = 8;
        block0: while (tries > 0) {
            --tries;
            double newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 180.0;
            double newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 2.0f;
            int intdist = (int)(newdist + (double)0.995f);
            double newx = e.posx + Math.cos(newdir += (double)this.rotation_yaw) * newdist;
            double newz = e.posz + Math.sin(newdir) * newdist;
            double newy = e.posy;
            int i = intdist;
            while (i > -intdist) {
                newy = this.posy + (double)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid((int)this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                    newy += 1.0;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }

    public void playAttackSound() {
        if (this.sound_busy != 0) {
            return;
        }
        int which = this.world.rand.nextInt(7);
        String sound = null;
        if (which == 0) {
            sound = "OreSpawn:o_fight1";
        }
        if (which == 1) {
            sound = "OreSpawn:o_fight2";
        }
        if (which == 2) {
            sound = "OreSpawn:o_fight3";
        }
        if (which == 3) {
            sound = "OreSpawn:o_fight4";
        }
        if (which == 4) {
            sound = "OreSpawn:o_fight5";
        }
        if (which == 5) {
            sound = "OreSpawn:o_fight6";
        }
        if (which == 6) {
            sound = "OreSpawn:o_fight7";
        }
        this.world.playSound(sound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        this.sound_busy = 20;
    }

    public void playTauntSound() {
        if (this.sound_busy != 0) {
            return;
        }
        int which = this.world.rand.nextInt(4);
        String sound = null;
        if (which == 0) {
            sound = "OreSpawn:o_taunt1";
        }
        if (which == 1) {
            sound = "OreSpawn:o_taunt2";
        }
        if (which == 2) {
            sound = "OreSpawn:o_taunt3";
        }
        if (which == 3) {
            sound = "OreSpawn:o_taunt4";
        }
        this.world.playSound(sound, this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
        this.sound_busy = 20;
    }

    public float getRightArmAngle() {
        return -this.armangle;
    }

    public void doEntityAction(float deltaT) {
        if (this.getOwnerName() != null) {
            this.temperament = 1;
            this.enable_avoid = false;
        } else {
            this.temperament = 3;
            this.enable_avoid = true;
        }
        if (!this.getStaying() && this.temperament == 1) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                if (!this.isSuitableTarget(this.hurtMe)) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                    this.setAttacking(true);
                    this.moveSpeed = 0.1f;
                } else {
                    this.setAttacking(false);
                    this.moveSpeed = 0.25f;
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(8) == 1) {
                if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                    InventoryContainer ic;
                    if (this.world.rand.nextInt(8) == 1) {
                        this.playAttackSound();
                    }
                    float dmg = this.getAttackDamage();
                    int dt = 4;
                    if (this.has_inventory && (ic = this.getHotbar(this.gethotbarindex())) != null) {
                        if (ic.bid != 0) {
                            dt = 3;
                        } else if (ic.iid > 0 && ic.iid < 2048) {
                            dmg = Items.getAttackStrength((int)ic.iid);
                            dt = 0;
                            Item it = ic.getItem();
                            if (it != null) {
                                if (it instanceof ItemSword) {
                                    dt = 1;
                                }
                                if (it instanceof ItemPickAxe) {
                                    dt = 2;
                                }
                                if (it instanceof ItemAxe) {
                                    dt = 2;
                                }
                                if (it instanceof ItemShovel) {
                                    dt = 2;
                                }
                            }
                        }
                    }
                    this.targetentity.doAttackFrom((Entity)this, dt, dmg);
                } else {
                    if (this.world.rand.nextInt(10) == 1) {
                        this.playTauntSound();
                    }
                    if (this.world.rand.nextInt(4) == 1) {
                        this.throwShoe();
                    }
                }
            }
        }
        ++this.secondcounter;
        if (this.secondcounter > 10) {
            double dist;
            Entity e;
            this.secondcounter = this.world.rand.nextInt(5);
            this.accellerator = 1.0f;
            if (this.getOwnerName() != null && !this.getStaying() && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (dist = this.getDistanceFromEntity(e)) > (double)this.maxdisttoowner) {
                this.accellerator = 1.75f;
                this.findNewTargetNearOwner(e);
                if (dist > (double)(this.maxdisttoowner * 2.0f)) {
                    this.target = null;
                    this.hurtMe = null;
                    this.accellerator = 1.0f;
                    if (e.getOnGround()) {
                        Dimensions.DimensionArray[e.dimension].teleportToDimension((Entity)this, this.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
                    }
                }
            }
        }
        if (!this.getStaying()) {
            if (this.shouldDance() && this.continueDance()) {
                this.updateDance();
            }
            super.doEntityAction(deltaT);
        }
    }

    public void throwShoe() {
        ThrownShoe e = (ThrownShoe)this.world.createEntityByName("OreSpawn:ThrownShoe", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.getWidth() + 1.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
        if (e != null) {
            e.init();
            e.setBID(0);
            int id = OreSpawnMain.blackheels.itemID;
            int which = this.world.rand.nextInt(4);
            if (which == 1) {
                id = OreSpawnMain.redheels.itemID;
            }
            if (which == 2) {
                id = OreSpawnMain.boots.itemID;
            }
            if (which == 3) {
                id = OreSpawnMain.slippers.itemID;
            }
            e.setIID(id);
            e.thrower = this;
            e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public void update(float deltaT) {
        if (this.sound_busy > 0) {
            --this.sound_busy;
        }
        super.update(deltaT);
    }

    public float getDefense() {
        float df = super.getDefense();
        if (this.getOwnerName() != null && df < 2.0f) {
            df = 2.0f;
        }
        return df;
    }

    public boolean isSuitableFood(Entity e) {
        Entity p;
        if (!(e instanceof EntityBlockItem)) {
            return false;
        }
        EntityBlockItem eb = (EntityBlockItem)e;
        if (!this.isFoodForMe(eb.getBlockID(), eb.getItemID())) {
            return false;
        }
        if (this.getOwnerName() != null && (p = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && p.getDistanceFromEntity((Entity)eb) > (double)this.maxdisttoowner) {
            return false;
        }
        return this.CanProbablySeeEntity((Entity)eb);
    }

    public boolean is_dance_block(int bid) {
        return bid == Blocks.blockplatinum.blockID || bid == Blocks.blockdiamond.blockID || bid == Blocks.blockemerald.blockID || bid == Blocks.blockbloodstone.blockID || bid == Blocks.blocksunstone.blockID || bid == Blocks.blocklight.blockID || bid == OreSpawnMain.blockamethyst.blockID || bid == OreSpawnMain.blocktigerseye.blockID || bid == OreSpawnMain.blockruby.blockID;
    }

    public boolean shouldDance() {
        if (this.getStaying()) {
            if (this.is_dancing != 0) {
                this.setAttacking(false);
                this.is_dancing = 0;
            }
            return false;
        }
        long t = this.world.getTimeOfDay();
        if (t < 220L || t > 320L) {
            if (this.is_dancing != 0) {
                this.setAttacking(false);
                this.is_dancing = 0;
            }
            return false;
        }
        int ic = 0;
        int i = -3;
        while (i < 4) {
            int j = -3;
            while (j < 4) {
                int bid = this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy - 1, (int)this.posz + j);
                if (this.is_dance_block(bid)) {
                    ++ic;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (ic == 0) {
            if (this.is_dancing != 0) {
                this.setAttacking(false);
                this.is_dancing = 0;
            }
            return false;
        }
        return true;
    }

    public boolean continueDance() {
        if (this.getStaying()) {
            return false;
        }
        long t = this.world.getTimeOfDay();
        if (t < 220L || t > 320L) {
            return false;
        }
        int ic = 0;
        int iz = 0;
        int ix = 0;
        int i = -3;
        while (i < 4) {
            int j = -3;
            while (j < 4) {
                int bid = this.world.getblock(this.dimension, (int)this.posx + i, (int)this.posy - 1, (int)this.posz + j);
                if (this.is_dance_block(bid)) {
                    ++ic;
                    ix += i;
                    iz += j;
                }
                ++j;
            }
            ++i;
        }
        if (ic == 0) {
            return false;
        }
        ix /= ic;
        iz /= ic;
        if (ic < 40) {
            this.target = new TargetHelper(this.posx + (double)ix, this.posy, this.posz + (double)iz);
        }
        this.is_dancing = 1;
        return true;
    }

    public void move_it(int t, int cycle, int dir) {
        float dirx = 0.0f;
        float dirz = 0.0f;
        float dirYaw = 0.0f;
        float dirYawH = 0.0f;
        switch (dir) {
            case 0: {
                dirx = 0.05f;
                dirz = 0.0f;
                dirYaw = 0.0f;
                dirYawH = 0.0f;
                break;
            }
            case 1: {
                dirx = 0.0f;
                dirz = 0.05f;
                dirYaw = 0.0f;
                dirYawH = 0.0f;
                break;
            }
            case 2: {
                dirx = 0.0f;
                dirz = 0.0f;
                dirYaw = 5.0f;
                dirYawH = 0.0f;
                break;
            }
            case 3: {
                dirx = 0.0f;
                dirz = 0.0f;
                dirYaw = 0.0f;
                dirYawH = 5.0f;
                break;
            }
        }
        if ((t %= cycle) >= cycle / 2) {
            dirx = -dirx;
            dirz = -dirz;
            dirYaw = -dirYaw;
            dirYawH = -dirYawH;
        }
        if ((t %= cycle / 2) >= cycle / 4) {
            dirYaw = -dirYaw;
            dirYawH = -dirYawH;
        }
        this.motionx += dirx;
        this.motionz += dirz;
        this.rotation_yaw += dirYaw;
        this.rotation_yaw_head += dirYawH;
    }

    public void updateDance() {
        int cycle = 10;
        int halfc = cycle / 2;
        int mover = cycle * 8;
        int tempid = this.entityID;
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(10.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (e == this || !(e instanceof Girlfriend) || e.entityID >= tempid) continue;
                Girlfriend g = (Girlfriend)e;
                if (g.is_dancing == 1) {
                    this.dance_ticker = g.dance_ticker;
                    this.dance_move = g.dance_move;
                }
                tempid = g.entityID;
            }
        }
        ++this.dance_ticker;
        this.setAttacking(false);
        if (this.dance_move == 0) {
            this.dance_move = 1 + this.world.rand.nextInt(9);
            this.motionx = 0.0f;
            this.motionz = 0.0f;
            this.dance_ticker = 0;
        }
        switch (this.dance_move) {
            case 1: {
                this.move_it(this.dance_ticker, cycle, 0);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 2: {
                this.move_it(this.dance_ticker, cycle, 1);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 3: {
                if (this.dance_ticker % halfc == 1) {
                    this.setAttacking(true);
                    this.motiony += 0.25f;
                }
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 4: {
                if (this.dance_ticker % halfc == 1) {
                    this.setAttacking(true);
                }
                this.move_it(this.dance_ticker, cycle, 0);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 5: {
                if (this.dance_ticker % halfc == 1) {
                    this.setAttacking(true);
                }
                this.move_it(this.dance_ticker, cycle, 1);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 6: {
                int cfr_ignored_0 = this.dance_ticker % cycle;
                this.move_it(this.dance_ticker, cycle, 0);
                this.move_it(this.dance_ticker, cycle, 2);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 7: {
                int cfr_ignored_1 = this.dance_ticker % cycle;
                this.move_it(this.dance_ticker, cycle, 1);
                this.move_it(this.dance_ticker, cycle, 2);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 8: {
                int cfr_ignored_2 = this.dance_ticker % cycle;
                if (this.dance_ticker % halfc == 1) {
                    this.setAttacking(true);
                }
                this.move_it(this.dance_ticker, cycle, 0);
                this.move_it(this.dance_ticker, cycle, 3);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            case 9: {
                int cfr_ignored_3 = this.dance_ticker % cycle;
                if (this.dance_ticker % halfc == 1) {
                    this.setAttacking(true);
                    this.motiony += 0.35f;
                }
                this.move_it(this.dance_ticker, cycle, 1);
                this.move_it(this.dance_ticker, cycle, 3);
                if (this.dance_ticker <= mover) break;
                this.dance_move = 0;
                break;
            }
            default: {
                this.dance_move = 0;
            }
        }
    }

    public boolean isRaining() {
        if (!Dimensions.DimensionArray[this.dimension].rain_enable) {
            return false;
        }
        if (!this.world.isServer) {
            return false;
        }
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(160.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                EntityCloud ec;
                int bid;
                e = (Entity)li.next();
                if (!(e instanceof EntityCloud) || (bid = (ec = (EntityCloud)e).getBID()) == Blocks.cloud_light.blockID || !(ec.getHorizontalDistanceFromEntity((Entity)this) < 20.0)) continue;
                return true;
            }
        }
        return false;
    }
}

